<?php

namespace App\Helpers\Image\Frames;

use App\Helpers\Image\ImageWorkshop;

abstract class Frame
{

    protected $frameFilePath;
    protected $width;
    protected $innerWidth;
    protected $height;
    protected $innerHeight;
    protected $innerX;
    protected $innerY;

    /**
     * @var \PHPImageWorkshop\Core\ImageWorkshopLayer
     */
    protected $document;

    protected $printScreenPath;

    public function __construct($printScreenPath)
    {
        $this->printScreenPath = $printScreenPath;
        $this->init();
    }

    abstract public function init();

    public function getImage()
    {
        $this->document = ImageWorkshop::initFromPath($this->frameFilePath);

        $screenShotLayer = ImageWorkshop::initFromPath($this->printScreenPath);
        $screenShotLayer->resizeInPixel($this->innerWidth, $this->innerHeight);
        $this->document->addLayer(1, $screenShotLayer, $this->innerX, $this->innerY);

        return $this->document;
    }

    /**
     * @return mixed
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * @return mixed
     */
    public function getHeight()
    {
        return $this->height;
    }
}