<?php

namespace App\Helpers\Image;

class Watermark
{
    public static function apply($dirName, $fileName)
    {
        $masterImage = ImageWorkshop::initFromPath($dirName . '/' . $fileName);

        $watermarkLayer = ImageWorkshop::initFromPath(public_path() . '/images/demo.png');
        $watermarkLayer->resizeInPixel($masterImage->getWidth(), null, true);
        $watermarkLayer->opacity(50);

        $top = ($masterImage->getHeight() / 2) - ($watermarkLayer->getHeight() / 2);

        $top = 0;
        while ($top < $masterImage->getHeight()) {
            $masterImage->addLayerOnTop($watermarkLayer, 0, $top, 'LT');
            $top += $watermarkLayer->getHeight();
        }

        $masterImage->save($dirName, $fileName);
    }
}
