<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Screen\Capture;

class ScreenCaptureProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(Capture::class, function ($app) {
            $capture = new Capture();
            // Jobs Location
            if (!is_dir(storage_path('app/screen/jobs'))) {
                mkdir(storage_path('app/screen/jobs'), 0755, true);
            }
            $capture->jobs->setLocation(storage_path('app/screen/jobs'));
            // Output Location
            if (!is_dir(storage_path('app/screen/files'))) {
                mkdir(storage_path('app/screen/files'), 0755, true);
            }
            $capture->output->setLocation(storage_path('app/screen/files'));

            $capture->setBinPath(base_path('bin'));

            return $capture;
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [Capture::class];
    }
}
