@extends('layouts.base')

@section('title', Config::get('settings.application.name'))

@section('css')
    <style type="text/css">
        body {
            background: none;
        }

        html {
            background: url({{ asset('images/home-bg.jpg') }}) no-repeat center center fixed;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
        }
    </style>
@endsection

@section('body')
    <nav class="navbar navbar-inverse navbar-fixed-bottom">
        <div class="container">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar"
                        aria-expanded="false" aria-controls="navbar">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="/">{{ Config::get('settings.application.name') }} (Demo)</a>
            </div>
            <div id="navbar" class="navbar-collapse collapse">
                <ul class="nav navbar-nav">
                    <li class="{{ $__env->yieldContent('active-menu') == 'showcase' ? 'active' : '' }}">
                        <a href="{{ url('showcase') }}">Showcase</a>
                    </li>
                    <li class="{{ $__env->yieldContent('active-menu') == 'printscreen' ? 'active' : '' }}">
                        <a href="{{ url('print-screen') }}">Print Screen</a>
                    </li>
                    <li><a href="http://codecanyon.net/" target="_blank">Buy</a></li>
                </ul>
            </div><!--/.nav-collapse -->
        </div>
    </nav>

    <div class="container">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <i id="home-icon" class="glyphicon glyphicon-camera"></i>
                <h1 id="home-web">Web</h1>
                <h1 id="home-photo">Photographer</h1>
                <p>
                    Ever wished you could showcase how responsive a website is with just one click? What if you could
                    save the results to your computer?
                </p>
                <p>
                    Well... you can do all that and even more with Web Photographer. Screenshot your website from
                    different angles. Show the world how it looks like.
                </p>
            </div>
        </div>
        <!-- /.row -->
    </div>
@endsection