<?php

namespace App\Helpers\Image;

use App\Helpers\Image\Frames\Desktop;
use App\Helpers\Image\Frames\Frame;
use App\Helpers\Image\Frames\Laptop;
use App\Helpers\Image\Frames\Phone;
use App\Helpers\Image\Frames\Tablet;
use PHPImageWorkshop\Core\ImageWorkshopLayer;
use App\Helpers\Image\ImageWorkshop;

class Showcase
{
    const TEMPLATE_ALL = 'all';
    const TEMPLATE_DESKTOP = 'desktop';
    const TEMPLATE_LAPTOP = 'laptop';
    const TEMPLATE_TABLET = 'tablet';
    const TEMPLATE_PHONE = 'phone';

    /**
     * @var Desktop
     */
    protected $desktopLayer;

    /**
     * @var Laptop
     */
    protected $laptopLayer;

    /**
     * @var Tablet
     */
    protected $tabletLayer;

    /**
     * @var Phone
     */
    protected $phoneLayer;

    protected $template = 'all';

    /**
     * @var ImageWorkshopLayer
     */
    protected $document;

    /**
     * @param mixed $desktopLayer
     * @return Showcase
     */
    public function setDesktopLayer(Frame $desktopLayer)
    {
        $this->desktopLayer = $desktopLayer->getImage();

        return $this;
    }

    /**
     * @param mixed $laptopLayer
     * @return Showcase
     */
    public function setLaptopLayer(Frame $laptopLayer)
    {
        $this->laptopLayer = $laptopLayer->getImage();

        return $this;
    }

    /**
     * @param mixed $tabletLayer
     * @return Showcase
     */
    public function setTabletLayer(Frame $tabletLayer)
    {
        $this->tabletLayer = $tabletLayer->getImage();

        return $this;
    }

    /**
     * @param mixed $phoneLayer
     * @return Showcase
     */
    public function setPhoneLayer(Frame $phoneLayer)
    {
        $this->phoneLayer = $phoneLayer->getImage();

        return $this;
    }

    public function setTemplate($templateName)
    {
        $this->template = $templateName;

        return $this;
    }

    public function getImage()
    {
        $resize = 600;

        switch ($this->template) {
            case self::TEMPLATE_DESKTOP:
                $this->width = $this->desktopLayer->getWidth() + 40;
                $this->height = $this->desktopLayer->getHeight() + 25;

                $this->document = ImageWorkshop::initVirginLayer($this->width, $this->height);
                $this->document->addLayer(1, $this->desktopLayer, 20, 10, 'LB');
                break;

            case self::TEMPLATE_LAPTOP:
                $this->width = $this->laptopLayer->getWidth() + 40;
                $this->height = $this->laptopLayer->getHeight() + 25;

                $this->document = ImageWorkshop::initVirginLayer($this->width, $this->height);
                $this->document->addLayer(1, $this->laptopLayer, 20, 10, 'LB');
                break;

            case self::TEMPLATE_TABLET:
                $this->width = $this->tabletLayer->getWidth() + 40;
                $this->height = $this->tabletLayer->getHeight() + 25;

                $this->document = ImageWorkshop::initVirginLayer($this->width, $this->height);
                $this->document->addLayer(1, $this->tabletLayer, 20, 10, 'LB');
                $resize = 400;
                break;

            case self::TEMPLATE_PHONE:
                $this->width = $this->phoneLayer->getWidth() + 40;
                $this->height = $this->phoneLayer->getHeight() + 25;

                $this->document = ImageWorkshop::initVirginLayer($this->width, $this->height);
                $this->document->addLayer(1, $this->phoneLayer, 20, 10, 'LB');
                $resize = 200;
                break;

            case self::TEMPLATE_ALL:
            default:
                $this->width = 1310;
                $this->height = 750;
                $resize = 800;

                $this->document = ImageWorkshop::initVirginLayer($this->width, $this->height);
                $this->document->addLayer(1, $this->desktopLayer, 220, 110, 'LB');
                $this->document->addLayer(2, $this->laptopLayer, 660, 20, 'LB');
                $this->document->addLayer(3, $this->tabletLayer, 90, 40, 'LB');
                $this->document->addLayer(4, $this->phoneLayer, 20, 10, 'LB');

                break;
        }

        $this->document->resizeInPixel($resize, null, true);

        return $this->document;
    }
}