<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::group(['middleware' => ['web']], function () {
    Route::get('/', function () {
        return view('pages.welcome');
    });
    Route::get('/showcase', function () {
        return view('pages.showcase');
    });
    Route::get('/print-screen', function () {
        return view('pages.printscreen');
    });
});

Route::group(['middleware' => ['ajax']], function () {
    Route::get('/api/showcase/{options}', 'ShowcaseController@generateShowcaseImage');
    Route::get('/api/print-screen/{options}', 'PrintScreenController@generatePrintScreenImage');
});
