#Web Photographer

Created at 15/08/2016 by André Filipe

Thank you for purchasing my application. If you have any questions that are beyond the scope of this help file, please feel free to email via my user page contact form. Thanks so much!

##1. Application Details

This is a web application that allows you to screenshot any website with the dimensions that you require.

It also lets you show case a website in 4 different tastes, desktop, laptop, tablet and phone. You can showcase a website in all 4 platforms at the same time. All generated automatically.

This showcases are mostly used to show off a website to the world, used on portfolios, landing pages, presentations, you name it. Usually it requires the common Joe to take multiple screenshots to a browser, resizing the window multiple times and then gluing all together with photoshop or any other image editing software.

With **Web Photographer** you can do that just by typing the url of the website and pressing one button, isn't that awesome?

##2. System Requirements

 * **PHP 5.5.9**
 * [**GD**](https://secure.php.net/manual/en/book.image.php) extension for PHP
 * [**exec**](https://secure.php.net/manual/en/function.exec.php) function must be enabled on PHP

##3. Installation Guide

Once all the application files are unzipped and in place (your server or something like this), execute the following command from the path were you uploaded the files.

For example, if you uploaded the files to /var/www/web-photographer you should be at that location

``` shell
php bin/setup.php
```

or 

``` shell
sudo php bin/setup.php
```

After that it should be good to go, now you can point your virtual host to /var/www/web-photographer/public

Then go to `config/app.php` and edit the line 42 where you will find this:

``` php
    'url' => env('APP_URL', 'http://localhost'),
```

You need to change the `http://localhost` to the url that you'll be using.

And that's it, it should be good to go.

##4. Licenses

* [**Composer**](https://getcomposer.org/) - [MIT](https://github.com/composer/composer/blob/master/LICENSE)
    * Package Manager
* [**Laravel**](https://laravel.com/) - [MIT](https://github.com/laravel/laravel#license)
    * Web application framework
* [**jQuery**](https://jquery.org/) - [MIT](https://jquery.org/license/)
* [**Bootstrap**](https://getbootstrap.com/) - [MIT](https://github.com/twbs/bootstrap/blob/master/LICENSE)
* [**Bootstrap Colorpicker**](http://mjolnic.com/bootstrap-colorpicker/) - [Apache License v2.0](https://github.com/mjolnic/bootstrap-colorpicker/blob/master/LICENSE)
* [**ImageWorkshop**](http://phpimageworkshop.com/) - [MIT](https://github.com/Sybio/ImageWorkshop/blob/master/LICENCE.txt)
    * Used to generate the showcase images.
* [**microweber/screen**](https://github.com/microweber/screen) - [MIT](https://github.com/microweber/screen/blob/master/LICENSE)
    * This lib is a wrapper in php to use the PhantomJS bin, wish is used to screenshot the html pages.
* [**PhantomJS**](http://phantomjs.org/) - [BSD](https://github.com/ariya/phantomjs/blob/master/LICENSE.BSD)
    * Used to programmatically capture web contents, including CSS, SVG and Canvas.