@extends('layouts.app')

@section('title', 'Print Screen - ' . Config::get('settings.application.name'))

@section('active-menu', 'printscreen')

@section('content')
    <div id="placeholder" style="display: none; background-color: #bfbfbf; overflow-y: auto;">
        <div class="container text-center">
            <img src="http://placehold.it/600x400" width="600" height="400">
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div id="printscreen-form">
                <h2>
                    Screenshot a website...
                </h2>

                <div class="form-group col-md-6">
                    <label for="url">URL</label>
                    <input type="url" class="form-control" name="url" placeholder="Website to Screenshot">
                </div>

                <div class="form-group col-md-2">
                    <label for="width">Page Width (px)</label>
                    <input type="number" name="width" class="form-control" placeholder="800" min="100"/>
                </div>

                <div class="form-group col-md-2">
                    <label for="height">Page Height (px)</label>
                    <input type="number" name="height" class="form-control" placeholder="0 = auto" min="0"/>
                </div>

                <div class="form-group col-md-2">
                    <label for="bg-color">Page background color</label>
                    <input type="text" name="bg-color" class="form-control color-picker"
                           data-format="hex" placeholder="auto"/>
                </div>

                <div class="col-md-12">
                    <button id="printscreen-submit" class="btn btn-default pull-right">
                        <i class="glyphicon glyphicon-cog spinning"></i>
                        Submit
                    </button>
                    <a id="btn-download" download href="" class="btn btn-info pull-right hidden"
                       style="margin-right: 5px;" target="_blank">Save</a>
                    <p id="label-wait" class="lead pull-right hidden">You may have to wait a little bit... &nbsp;</p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    <link rel="stylesheet" href="https://cdn.rawgit.com/farbelous/bootstrap-colorpicker/70f369a7/dist/css/bootstrap-colorpicker.min.css">
@endsection

@section('javascript')
    <script src="https://cdn.rawgit.com/farbelous/bootstrap-colorpicker/70f369a7/dist/js/bootstrap-colorpicker.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.color-picker').colorpicker();

            var placeholderMaxHeight = $(window).height() - 250;
            $('#placeholder').css('max-height', placeholderMaxHeight);

            $('#printscreen-submit').click(function (event) {
                event.preventDefault();
                $('#label-wait').removeClass('hidden');
                $('#btn-download').addClass('hidden');
                $('#printscreen-submit').addClass('active');

                var options = {
                    url: $('#printscreen-form input[name=url]').val(),
                    width: $('#printscreen-form input[name=width]').val(),
                    height: $('#printscreen-form input[name=height]').val(),
                    bgColor: $('#printscreen-form input[name=bg-color]').val()
                };

                if (options.width == '') {
                    options.width = 800;
                } else {
                    options.width = parseInt(options.width);
                }

                if (options.height == '') {
                    options.height = 0;
                } else {
                    options.height = parseInt(options.height);
                }

                var base64 = btoa(JSON.stringify(options));

                $.get('{{ url('api/print-screen') }}/' + base64, function (response) {

                    var img = '<img src="' + response.image.src + '" width="' + response.image.width + '" height="' + response.image.height + '">';
                    $('#btn-download').attr('href', response.image.src);

                    $('#placeholder').slideUp('fast', function () {
                        $('#placeholder .container').html(img);

                        $('#placeholder').slideDown("slow", function () {
                            $('#btn-download').removeClass('hidden');
                            $('#printscreen-submit').removeClass('active');
                        });
                    });
                });
            })
        });
    </script>
@endsection