

<?php $__env->startSection('title', 'Showcase - ' . Config::get('settings.application.name')); ?>

<?php $__env->startSection('active-menu', 'showcase'); ?>

<?php $__env->startSection('content'); ?>
    <div id="placeholder" style="display: none;">
        <div class="container text-center">
            <img src="http://placehold.it/600x400" width="600" height="400">
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div id="showcase-form">
                <h2>
                    Showcase a website...
                    <small>show the world how responsive it is</small>
                </h2>

                <div class="form-group col-md-8">
                    <label for="url">URL</label>
                    <input type="url" class="form-control" name="url" placeholder="Website to Showcase">
                </div>

                <div class="form-group col-md-2">
                    <label for="bg-color">Template</label>
                    <select name="template" class="form-control">
                        <option value="all">All Devices</option>
                        <optgroup label="Single Device">
                            <option value="desktop">Desktop</option>
                            <option value="laptop">Laptop</option>
                            <option value="tablet">Tablet</option>
                            <option value="phone">Phone</option>
                        </optgroup>
                    </select>
                </div>

                <div class="form-group col-md-2">
                    <label for="bg-color">Background color</label>
                    <input type="text" name="bg-color" class="form-control color-picker" placeholder="Transparent"
                           data-format="hex"/>
                </div>

                <div class="col-md-12">
                    <button id="showcase-submit" class="btn btn-default pull-right">
                        <i class="glyphicon glyphicon-cog spinning"></i>
                        Submit
                    </button>
                    <a id="btn-download" download href="" class="btn btn-info pull-right hidden"
                       style="margin-right: 5px;" target="_blank">Save</a>
                    <p id="label-wait" class="lead pull-right hidden">You may have to wait a little bit... &nbsp;</p>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet"
          href="https://cdn.rawgit.com/farbelous/bootstrap-colorpicker/70f369a7/dist/css/bootstrap-colorpicker.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="https://cdn.rawgit.com/farbelous/bootstrap-colorpicker/70f369a7/dist/js/bootstrap-colorpicker.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.color-picker').colorpicker();

            $('#showcase-submit').click(function (event) {
                event.preventDefault();
                $('#label-wait').removeClass('hidden');
                $('#btn-download').addClass('hidden');
                $('#showcase-submit').addClass('active');

                var options = {
                    url: $('#showcase-form input[name=url]').val(),
                    template: $('#showcase-form select[name=template]').val(),
                    bgColor: $('#showcase-form input[name=bg-color]').val()
                };

                var base64 = btoa(JSON.stringify(options));

                $.get('<?php echo e(url('api/showcase')); ?>/' + base64, function (response) {

                    var img = '<img src="' + response.image.src + '" width="' + response.image.width + '" height="' + response.image.height + '">';
                    $('#btn-download').attr('href', response.image.src);

                    $('#placeholder').slideUp('fast', function () {
                        $('#placeholder .container').html(img);
                        $('#placeholder').css('background-color', response.options.bgColor);
                        $('#placeholder').slideDown("slow", function () {
                            $('#btn-download').removeClass('hidden');
                            $('#showcase-submit').removeClass('active');
                        });
                    });
                });
            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>