<?php
include_once('../include/webzone.php');

$category_id = $_GET['c'];

$active_page = 'upload';
include_once('../include/presentation/header_admin.php');
?>

<script>

function loadUploadImagesForm() {
	Formstone.Ready(function() {
	    $(".fs-upload").upload({
	        action: "../listeners/admin/upload_image.php",
	        postData: {'categoryId':<?php echo $category_id; ?>},
	        dataType: 'json'
        })
        .on("filecomplete.upload", onFileComplete)
        .on("fileerror.upload", onFileError);
	});
}

function onFileComplete(e, file, response) {
	console.log(response);
	
	if(response.success===true) {
		
		$('#upload_result').append(response.html);
	}
	else {
		alert(response.errorMessage);
	}
}

function onFileError(e, file, response) {
	console.log('Unexpected error'+response);
}

$(document).ready(function() {
	loadUploadImagesForm();
});

</script>

<div class="container">	
	
	<h2>Ladda upp bilder</h2><hr><br>
	
	<?php
	
	$categories = get_categories();
	for($i=0; $i<count($categories); $i++) {
		$categories_tab[$categories[$i]['id']] = $categories[$i]['name'];
	}
	
	echo '<form name="form" method="get" style="padding-bottom:5px;">';
		echo 'Var god välj kategori att ladda upp till: <select name="c" onchange="form.submit();"><option></option>';
		foreach($categories_tab as $ind=>$value) {
			if($ind==$category_id) echo '<option value="'.$ind.'" selected>'.$value.'</option>';
			else echo '<option value="'.$ind.'">'.$value.'</option>';
		}
		echo '</select> ';
		
		if($category_id!='') echo '&nbsp - &nbsp;<a href="./photos.php?c='.$category_id.'">Visa det här galleriet</a>';
		
	echo '</form>';
	
	if($category_id>0) {
		
		if($GLOBALS['demo_mode']!=1) {
			?>
			<div class="fs-upload fs-dropdown"></div>
			<p id="upload_result" style="margin-top:10px;"></p>
			
			<?php
		}
		else {
			echo 'The uploader button is not available in the demo mode!';
		}
	}
	
	?>
		
</div>

<?
include_once('../include/presentation/footer_admin.php');
?>