<?php

function get_images($criteria=array()) {
	$category_id = $criteria['category_id'];
	$order = $criteria['order'];
	$page_number = $criteria['page_number'];
	$nb_display = $criteria['nb_display'];
	
	if($page_number=='') $page_number=1;
	if($nb_display=='') $nb_display=10;
	if($order=='') $order='id DESC';
	
	$start = $page_number*$nb_display-$nb_display;
	
	$u1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['images']." WHERE 1";
	
	if($category_id!='') $sql .= " AND category_id='".$u1->escape($category_id)."'";
	
	$sql .= " ORDER BY $order";
	$sql .= " LIMIT $start, $nb_display";
	
	$result = $u1->customQuery($sql);
	
	$image_path = $GLOBALS['app_url'].'/'.$GLOBALS['uploads']['folder_name'].'/';
	for($i=0; $i<count($result); $i++) {
		$result[$i]['img_thumb'] = $image_path.$result[$i]['name'];
		$result[$i]['img_source'] = $image_path.$result[$i]['name'];
	}
	
	return $result;
}

function get_nb_images($criteria=array()) {
	$category_id = $criteria['category_id'];
	
	$u1 = new MySqlTable();
	$sql = "SELECT count(*) nb FROM ".$GLOBALS['db_table']['images']." WHERE 1";
	
	if($category_id!='') $sql .= " AND category_id='".$u1->escape($category_id)."'";
	
	$result = $u1->customQuery($sql);
	
	return $result[0]['nb'];
}

function get_total_by_category() {
	$s1 = new MySqlTable();
	
	$sql = 'SELECT category_id, count(*) nb FROM '.$GLOBALS['db_table']['images'].' GROUP BY category_id';
	$result = $s1->customQuery($sql);
	for($i=0; $i<count($result); $i++) {
		$total[$result[$i]['category_id']] = $result[$i]['nb'];
	}
	return $total;
}

function get_categories($criteria=array()) {
	$order = $criteria['order'];
	
	if($order=='') $order = 'name';
	
	$u1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['categories']." WHERE 1";
	
	if($order!='') $sql .= " ORDER BY $order";
	
	$result = $u1->customQuery($sql);
	
	return $result;
}

/*
function update_invites($criteria=array()) {
	$fb_user_id = $criteria['fb_user_id'];
	$fb_name = $criteria['fb_name'];
	$fb_email = $criteria['fb_email'];
	$nb_invites = $criteria['nb_invites'];
	$invited_ids = $criteria['invited_ids'];
	$nb_invites_db = $criteria['nb_invites_db'];
	$daily_nb_invites_db = $criteria['daily_nb_invites_db'];
	
	if($fb_user_id!='') {
		
		$results = get_invites(array('fb_user_id'=>$fb_user_id));
		
		if(count($results)>0) {
			$sql = "UPDATE ".$GLOBALS['db_table']['inviter']." 
			SET nb_invites='".($nb_invites+$nb_invites_db)."', invited_ids='$invited_ids', daily_nb_invites='".($nb_invites+$daily_nb_invites_db)."', date='".time()."'
			WHERE fb_user_id='$fb_user_id'";
			$u1 = new MySqlTable();
			$u1->executeQuery($sql);
		}
		else {
			$sql = "INSERT INTO ".$GLOBALS['db_table']['inviter']." 
			(fb_user_id, fb_name, fb_email, nb_invites, invited_ids, daily_nb_invites, date, created) 
			VALUES ('$fb_user_id', '$fb_name', '$fb_email', '$nb_invites', '$invited_ids', '$nb_invites', '".time()."', '".date('Y-m-d H:i:s')."')";
			$u1 = new MySqlTable();
			$u1->executeQuery($sql);
		}
	}
}

function get_invites($criteria=array()) {
	$fb_user_id = $criteria['fb_user_id'];
	
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['inviter']." WHERE 1";
	
	if($fb_user_id!='') $sql .= " AND fb_user_id='$fb_user_id'";
	
	$u1 = new MySqlTable();
	$result = $u1->customQuery($sql);
	
	return $result;
}

function get_invites_history($criteria=array()) {
	$fb_user_id = $criteria['fb_user_id'];
	
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['inviter_history']." WHERE 1";
	
	if($fb_user_id!='') $sql .= " AND fb_user_id='$fb_user_id'";
	
	$sql .= ' ORDER BY date DESC';
	
	$u1 = new MySqlTable();
	$result = $u1->customQuery($sql);
	
	if($GLOBALS['demo_mode']) {
		for($i=0; $i<count($result); $i++) {
			$result[$i]['friend_name'] = 'Name (hidden in demo mode)';
		}
	}
	
	return $result;
}

function get_users($criteria=array()) {
	$id = $criteria['id'];
	$fb_user_id = $criteria['fb_user_id'];
	
	$u1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['inviter']." WHERE 1";
	
	if($id!='') $sql .= " AND id='".$u1->escape($id)."'";
	if($fb_user_id!='') $sql .= " AND fb_user_id='".$u1->escape($fb_user_id)."'";
	
	$sql .= ' ORDER BY created DESC';
	
	$result = $u1->customQuery($sql);
	
	if($GLOBALS['demo_mode']) {
		for($i=0; $i<count($result); $i++) {
			$result[$i]['fb_name'] = 'Name (hidden in demo mode)';
		}
	}
	
	return $result;		
}

function add_history($criteria=array()) {
	$fb_user_id = $criteria['fb_user_id'];
	$friend_user_id = $criteria['friend_user_id'];
	$friend_name = $criteria['friend_name'];
	$message_id = $criteria['message_id'];
	
	$u1 = new MySqlTable();
	$sql = "INSERT INTO ".$GLOBALS['db_table']['inviter_history']." (fb_user_id, friend_user_id, friend_name, message_id, date) VALUES 
	('".$u1->escape($fb_user_id)."', '".$u1->escape($friend_user_id)."', '".$u1->escape($friend_name)."', '".$u1->escape($message_id)."', '".time()."')";
	
	$u1->executeQuery($sql);
}
*/

function get_settings($criteria=array()) {
	$meta_key = $criteria['meta_key'];
	$num = $criteria['num'];
	
	$s1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['inviter_settings']." WHERE 1";
	if($num!='') $sql .= " AND num='".$s1->escape($num)."'";
	if($meta_key!='') $sql .= " AND meta_key='".$s1->escape($meta_key)."'";
	
	$result = $s1->customQuery($sql);
	return $result;
}

function delete_setting($key) {
	$s1 = new MySqlTable();
	$sql = "DELETE FROM ".$GLOBALS['db_table']['inviter_settings']." WHERE meta_key='".$s1->escape($key)."'";
	$s1->executeQuery($sql);
}

function add_setting($key, $value, $num='') {
	if($key!='') {
		$s1 = new MySqlTable();
		$result = get_settings(array('meta_key'=>$key, 'num'=>$num));
		if(count($result)>0) {
			$sql = "UPDATE ".$GLOBALS['db_table']['inviter_settings']." SET meta_value='".$s1->escape($value)."' WHERE meta_key='".$s1->escape($key)."'";
			if($num!='') $sql .= " AND num='".$s1->escape($num)."'";
			$s1->executeQuery($sql);
		}
		else {
			$sql = "INSERT INTO ".$GLOBALS['db_table']['inviter_settings']." (meta_key, meta_value, num) VALUES ('".$s1->escape($key)."', '".$s1->escape($value)."', '".$s1->escape($num)."')";
			$s1->executeQuery($sql);
		}
	}
}

/*
START Default add/update functions
*/

function save_posted_data($data, $table_name) {
	
	$s1 = new MySqlTable();
	
	$fields='';
	$fields_values='';
	if(count($data)>0) {
		foreach($data as $ind => $value) {
			$fields .= $s1->escape($ind).',';
			$fields_values .= "'".$s1->escape($value)."',";
		}
	}
	
	$fields = substr($fields,0,-1);
	$fields_values = substr($fields_values,0,-1);
	
	$sql = "INSERT INTO $table_name ($fields) VALUES ($fields_values)";
	$s1->executeQuery($sql);
	$result = mysqli_insert_id($s1->link);
	
	return $result;
}

function update_posted_data($data, $id, $table_name) {
	
	$s1 = new MySqlTable();
	
	$fields='';
	if(count($data)>0) {
		foreach($data as $ind => $value) {
			$fields .= $s1->escape($ind)."='".$s1->escape($value)."',";
		}
	}
	
	$fields = substr($fields,0,-1);
	$fields_values = substr($fields_values,0,-1);
	
	$sql = "UPDATE $table_name SET $fields WHERE id='".$s1->escape($id)."'";
	
	$s1->executeQuery($sql);
}

?>