<?php

function display_galleria($criteria=array()) {
	$images = $criteria['images'];
	
	$image_path = $GLOBALS['app_url'].'/'.$GLOBALS['uploads']['folder_name'].'/';
	
	$d .= '<div id="galleria">';
	
	for($i=0; $i<count($images); $i++) {
		$id = $images[$i]['id'];
		$caption = $images[$i]['caption'];
		
		$img_thumb = $image_path.'mini/'.$images[$i]['name'];
		$img_source = $image_path.$images[$i]['name'];
		
		$d .= '<a href="'.$img_source.'">';
		$d .= '<img data-description="'.$caption.'" src="'.$img_thumb.'">';
        $d .= '</a>';
	}
	
	$d .= '</div>';
	
	return $d;
}

function display_images($criteria=array()) {
	$images = $criteria['images'];
	$style = $criteria['style'];
	
	$image_path = $GLOBALS['app_url'].'/'.$GLOBALS['uploads']['folder_name'].'/';
	
	for($i=0; $i<count($images); $i++) {
		$id = $images[$i]['id'];
		$caption = $images[$i]['caption'];
		
		$img_thumb = $image_path.'mini/'.$images[$i]['name'];
		$img_source = $image_path.$images[$i]['name'];
		
		$d .= display_single_image(array('style'=>$style, 'img_thumb'=>$img_thumb, 'img_source'=>$img_source, 'caption'=>$caption));
	}
	
	if(count($images)==0) $d .= 'Finns inga bilder';
	
	$d .= '<div style="clear:both;"></div>';
	return $d;
}

function display_single_image($criteria=array()) {
	$style = $criteria['style'];
	$img_thumb = $criteria['img_thumb'];
	$img_source = $criteria['img_source'];
	$caption = $criteria['caption'];
	
	if($style=='shadow') {
		$d .= '<div class="imageBox_1 tiptip '.$style.'" title="'.$caption.'">';
			$d .= '<a href="'.$img_source.'" rel="group" class="fancybox preview">';
			$d .= '<span class="image-wrap" style="position:relative; display:inline-block; background:url('.$img_thumb.') no-repeat center center;">';
			$d .= '<img src="'.$img_thumb.'" style="opacity:0;">';
			$d .= '</a><br>';			
		$d .= '</div>';	
	}
	else {
		$d .= '<div class="imageBox_1 tiptip '.$style.'" title="'.$caption.'">';
			$d .= '<a href="'.$img_source.'" rel="group" class="fancybox preview" title="'.$caption.'">';
			$d .= '<img src="'.$img_thumb.'">';
			$d .= '</a><br>';			
		$d .= '</div>';
	}
	
	return $d;
}

function display_images_admin($criteria=array()) {
	$images = $criteria['images'];
	
	for($i=0; $i<count($images); $i++) {
		$id = $images[$i]['id'];
		$name = $images[$i]['name'];
		$img_thumb = $images[$i]['img_thumb'];
		$img_source = $images[$i]['img_source'];
		$caption = $images[$i]['caption'];
		$created = $images[$i]['created'];
		
		if($caption=='') $tmp_css = 'bullet_red';
		else $tmp_css = 'bullet_green';
		
		/*
		echo '<div class="ygp-gallery tiptip" id="img_'.$id.'" title="'.$caption.'">';
			
			echo '<div>';
			echo '<a href="'.$img_source.'" rel="group" class="fancybox" title="'.$caption.'">';
			echo '<img src="'.$img_thumb.'" class="ygp-gallery-item">';
			echo '</a><br>';
			echo '<span>
			<a href="#" id="'.$id.'" class="delete_img_btn delete">RADERA</a>
			 <a href="#" id="'.$id.'" class="display_edit_caption_btn" title="'.$caption.'" data-img-thumb="'.$img_thumb.'"></a>
			</span>';
			echo '</div>';
			
		echo '</div>';
		*/
		
		echo '<div class="imageBox tiptip" id="img_'.$id.'" title="'.$caption.'">';
			
			echo '<a href="'.$img_source.'" rel="group" class="fancybox" title="'.$caption.'">';
			echo '<img src="'.$img_thumb.'" style="margin-bottom:5px;" class="ygp-gallery-item">';
			echo '</a><br>';
			echo '<span>
			<a href="#" id="'.$id.'" class="delete_img_btn delete">RADERA</a>
			 <a href="#" id="'.$id.'" class="display_edit_caption_btn" title="'.$caption.'" data-img-thumb="'.$img_thumb.'"></a>
			</span>';
			
		echo '</div>';
	}
	
	if(count($images)==0) echo 'Finns inga bilder';
	
	echo '<div style="clear:both;"></div>';
}

function display_pagination($criteria=array()) {
	$page_number = $criteria['page_number'];
	$nb_display = $criteria['nb_display'];
	$nbTotal = $criteria['nbTotal'];
	$nbPageMax = $criteria['nbPageMax'];
	
	if(count($_GET)>0) {
		$nb = count($_GET);
		foreach($_GET as $ind=>$value) {
			if($ind!='page') {
				$getParam .= $ind.'='.$value.'&';
			}
		}
		$getParam = '?'.substr($getParam,0,-1).'&';
	}
	else {
		$getParam = '?';
	}
	
	if($nbPageMax=='') $nbPageMax=10;
	
	$begin = $page_number;
	if($nb_display!=0) $nbPageResult = ceil($nbTotal/$nb_display);
	$end = $nbPageResult;
	
	$diff=$end-$begin;
	if($diff<$nbPageMax || $begin==$end) {
		$begin = $end-$nbPageMax;
		if($begin<1) $begin=1;
	}
	
	/*
	echo '$nbTotal: '.$nbTotal.'<br>';
	echo '$begin: '.$begin.'<br>';
	echo '$end: '.$end.'<br>';
	echo '$nbPageResult: '.$nbPageResult.'<br>';
	*/
	
	if($nbTotal>0 && $nbTotal>$nb_display) {
		
		$display .= '<center>';
		if($page_number>1) {
			$display .= '<a class="y_pagination display_gallery_btn" href="'.$getParam.'page='.($page_number-1).'" title="'.($page_number-1).'"><small>Tillbaka</small></a>&nbsp;'; //($previous+1)
		}
		
		for ($i=$begin; $i<=$end; $i++) {
		  if ($i == $page_number)  $display .= '<span class="y_pagination_current">'.$i.'</span>&nbsp;';
		  else {
		  	$display .= '<a class="y_pagination display_gallery_btn" href="'.$getParam.'page='.$i.'" title="'.$i.'"><small>'.$i.'</small></a>&nbsp;';
		  }
		}
		
		if($page_number<ceil($nbPageResult)) {
			$display .= '<a class="y_pagination display_gallery_btn" href="'.$getParam.'page='.($page_number+1).'" title="'.($page_number+1).'"><small>N&auml;sta</small></a>'; //($next+1)
		}
		$display .= '</center>';
	}
	
	return $display;
}

?>