<?php

// http://www.linuxjournal.com/article/9585
function check_email_address($email) {
  // First, we check that there's one @ symbol, 
  // and that the lengths are right.
  if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
    // Email invalid because wrong number of characters 
    // in one section or wrong number of @ symbols.
    return false;
  }
  // Split it into sections to make life easier
  $email_array = explode("@", $email);
  $local_array = explode(".", $email_array[0]);
  for ($i = 0; $i < sizeof($local_array); $i++) {
    if
(!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$",
$local_array[$i])) {
      return false;
    }
  }
  // Check if domain is IP. If not, 
  // it should be valid domain name
  if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
    $domain_array = explode(".", $email_array[1]);
    if (sizeof($domain_array) < 2) {
        return false; // Not enough parts to domain
    }
    for ($i = 0; $i < sizeof($domain_array); $i++) {
      if
(!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$",
$domain_array[$i])) {
        return false;
      }
    }
  }
  return true;
}

function getDataFromUrl($url) {
	$ch = curl_init();
	$timeout = 5;
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
	$data = curl_exec($ch);
	curl_close($ch);
	return $data;
}

function removeSpaces($text) {
	$text = trim($text);
	$text = preg_replace("/ -+/","-",$text);
	$text = preg_replace("/- +/","-",$text);
	$text = preg_replace("/ +/","-",$text); // remplace les espaces par -
	return $text;
}

function cleanURLString($string) {
	$encoding = mb_detect_encoding($string, 'auto');
	if($encoding=='UTF-8') $string = utf8_decode($string);
    $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿ';
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby';
    $string = strtr($string, $a, $b);
    $string = strtolower($string);
	//echo $string.'<br>';
    $string = eregi_replace("[^a-z0-9]",' ',$string);
    $string = removeSpaces($string);
    return $string;
}

function currentPageURL() {
	$pageURL = 'http';
	if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	}
	else {
		$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	}
	return $pageURL;
}

/**
* directory_list
* return an array containing optionally all files, only directiories or only files at a file system path
* @author     cgray The Metamedia Corporation www.metamedia.us
*
* @param    $base_path         string    either absolute or relative path
* @param    $filter_dir        boolean    Filter directories from result (ignored except in last directory if $recursive is true)
* @param    $filter_files    boolean    Filter files from result
* @param    $exclude        string    Pipe delimited string of files to always ignore
* @param    $recursive        boolean    Descend directory to the bottom?
* @return    $result_list    array    Nested array or false
* @access public
* @license    GPL v3
*/
function directory_list($directory_base_path, $filter_dir = false, $filter_files = false, $exclude = ".|..|.DS_Store|.svn", $recursive = true){
    $directory_base_path = rtrim($directory_base_path, "/") . "/";

    if (!is_dir($directory_base_path)){
        error_log(__FUNCTION__ . "File at: $directory_base_path is not a directory.");
        return false;
    }

    $result_list = array();
    $exclude_array = explode("|", $exclude);

    if (!$folder_handle = opendir($directory_base_path)) {
        error_log(__FUNCTION__ . "Could not open directory at: $directory_base_path");
        return false;
    }else{
        while(false !== ($filename = readdir($folder_handle))) {
            if(!in_array($filename, $exclude_array)) {
                if(is_dir($directory_base_path . $filename . "/")) {
                    if($recursive && strcmp($filename, ".")!=0 && strcmp($filename, "..")!=0 ){ // prevent infinite recursion
                        error_log($directory_base_path . $filename . "/");
                        $result_list[$filename] = directory_list("$directory_base_path$filename/", $filter_dir, $filter_files, $exclude, $recursive);
                    }elseif(!$filter_dir){
                        $result_list[] = $filename;
                    }
                }elseif(!$filter_files){
                    $result_list[] = $filename;
                }
            }
        }
        closedir($folder_handle);
        return $result_list;
    }
}

function get_directory_files($criteria=array()) {
	$directory = $criteria['directory'];
	$extentions_filter = $criteria['extensions']; //array of possible extensions
	
	$files = directory_list($directory, false, false, '', false);
	
	if(count($extentions_filter)>0) {
		for($i=0; $i<count($files); $i++) {
			$extension = substr(strrchr($files[$i],'.'),1);
			if(in_array($extension, $extentions_filter)) {
				$files2[] = $files[$i];
			}
		}
		$files = $files2;
	}
	
	return $files;
}

//split a CSV row
function csv_split($line,$delim=',',$removeQuotes=true) { 
    $fields = array(); 
    $fldCount = 0; 
    $inQuotes = false; 
    for ($i = 0; $i < strlen($line); $i++) { 
        if (!isset($fields[$fldCount])) $fields[$fldCount] = ""; 
        $tmp = substr($line,$i,strlen($delim)); 
        if ($tmp === $delim && !$inQuotes) { 
            $fldCount++; 
            $i += strlen($delim)-1; 
        } else if ($fields[$fldCount] == "" && $line[$i] == '"' && !$inQuotes) { 
            if (!$removeQuotes) $fields[$fldCount] .= $line[$i]; 
            $inQuotes = true; 
        } else if ($line[$i] == '"') { 
            if ($line[$i+1] == '"') { 
                $i++; 
                $fields[$fldCount] .= $line[$i]; 
            } else { 
                if (!$removeQuotes) $fields[$fldCount] .= $line[$i]; 
                $inQuotes = false; 
            } 
        } else { 
            $fields[$fldCount] .= $line[$i]; 
        } 
    } 
    return $fields; 
} 

//split a CSV by rows
function getCsvDataFromFile($file, $delimiter) {
    if (($handle = fopen($file, 'r')) !== FALSE) {
    	$row=0;
	    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
	        $num = count($data);
	        $row++;
	        for ($c=0; $c < $num; $c++) {
	            $data2[$row][] = $data[$c];
	        }
	    }
        fclose($handle);
    }
    return $data2; 
}

?>