Ygp_gallery = {};

jQuery('.display_image').live('click', function(event) {
	event.preventDefault();
	var url = $(this).attr('href');
	var title = $(this).attr('title');
	$('#big_image').html('<img src="'+url+'" style="width:100%;">');
	$('#big_image_caption').html(title);
});

$(".select_all").live("focus keyup", function(e){
    var keycode = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;
    if(keycode === 9 || !keycode){
        var $this = $(this);
        $this.select();
        
        $this.on("mouseup", function() {
            $this.off("mouseup");
            return false;
        });
    }
});

jQuery('#ygp_category').live('change', function(event) {
	var category_id = $(this).val();
	Ygp_gallery.category_id = category_id;
	Ygp_gallery.page_number = 1;
	display_gallery();
});

jQuery('.display_gallery_btn').live('click', function(event) {
	event.preventDefault();
	Ygp_gallery.page_number = $(this).attr('title');
	display_gallery();
});

function func(msg) {
	$('#ygp_gallery').html(msg.display);
	
	if(Ygp_gallery.type=='') {
		$(".fancybox").fancybox({
		maxWidth	: 800,
		maxHeight	: 600,
		width		: "70%",
		height		: "70%",
		helpers : 	{
					title : { 	type : "inside" },
					buttons	: {}
					}
		});
		
		if(Ygp_gallery.tooltip=='on') imagePreview();		
	}
	else if(Ygp_gallery.type==2) {
		Galleria.loadTheme(Ygp_gallery.path+"/include/js/galleria/themes/classic/galleria.classic.min.js");
		Galleria.run("#galleria");
	}
}

function display_gallery() {
	$.ajax({
		type: 'GET',
		data: 'path='+Ygp_gallery.path+'&category_id='+Ygp_gallery.category_id+'&category_filter='+Ygp_gallery.category_filter +'&tooltip='+Ygp_gallery.tooltip+'&style='+Ygp_gallery.style+'&background='+Ygp_gallery.background+'&nb_display='+Ygp_gallery.nb_display+'&page_number='+Ygp_gallery.page_number+'&type='+Ygp_gallery.type+'&width='+Ygp_gallery.width+'&height='+Ygp_gallery.height,
		dataType: 'jsonp',
		url: Ygp_gallery.path + '/api.php'
	});
}
